$regfile = "m8def.dat"
$crystal = 1000000

'################################################ EEPROM data
$eeprom
Data 0 , 5 , 45 , 0 , 0
'1==>alarm hours
'2==>alarm minutes
'3==>alarm PM
'4==>alarmon

'################################################ Subroutines declaration
Declare Sub Cleardispdata                                   'to clear 7 segment display turning it full off
Declare Sub Showdispdata(byref E As Byte)                   'show individual segment data on the segment
Declare Sub Rtcread                                         'full read the RTC chip
Declare Sub Blinkers_on                                     'turn on the two LEDs between segments
Declare Sub Blinkers_off                                    'turn off the two LEDs between segments
Declare Sub Beep(byval Dur As Word)                         'beep for a certain duration in milliseconds
Declare Sub Display_set                                     'used to display "SET" on 7 segment
Declare Sub Writertcreg(byval Address As Byte , Byval Value As Byte)       'used to write data to a register in RTC BQ32000
Declare Sub Blanking                                        'used to blank out the display

'################################################ ADC configuration
Config Adc = Single , Prescaler = Auto , Reference = Internal_2.56
Stop Adc

'################################################ PORTS configuration
'>>>>>>>>>>>>> RGB LED
Config Portb.3 = Output                                     'BLUE LED <== RGB LED
Config Portb.4 = Output                                     'GREEN LED <== RGB LED
Config Portb.5 = Output                                     'RED LED <== RGB LED
Red Alias Portb.5
Green Alias Portb.4
Blue Alias Portb.3

'>>>>>>>>>>>>> 7 segment display
Config Portb.1 = Output                                     ' 1st digit control line <==7segment display_LSB
Config Portb.2 = Output                                     ' 2nd digit control line <==7segment display
Config Portb.7 = Output                                     ' 3rd digit control line <==7segment display
Config Portb.6 = Output                                     ' 4th digit control line <==7segment display_MSB

Config Portd.0 = Output                                     ' g segment <==7segment display
Config Portd.1 = Output                                     ' e segment <==7segment display
Config Portd.4 = Output                                     ' d segment <==7segment display
Config Portd.5 = Output                                     ' c segment <==7segment display
Config Portd.6 = Output                                     ' b segment <==7segment display
Config Portd.7 = Output                                     ' a segment <==7segment display
Config Portb.0 = Output                                     ' f segment <==7segment display

'>>>>>>>>>>>>> Buttons
Config Pind.2 = Input                                       ' INT0 IRQ from BQ32000
Config Pind.3 = Input                                       ' INT1-SET button
Config Pinc.1 = Input                                       ' PLUS button
Config Pinc.2 = Input                                       ' MINUS button
Set Portd.3                                                 'turn internal pullups
Set Portc.1                                                 'turn internal pullups
Set Portc.2                                                 'turn internal pullups

B_set Alias Pind.3
B_plus Alias Pinc.1
B_minus Alias Pinc.2

'>>>>>>>>>>>>> Buzzer
Config Portc.0 = Output                                     'buzzer
Set Portc.0                                                 'turn off buzzer

'>>>>>>>>>>>>> TMP35
Config Pinc.3 = Input                                       'TMP35 input

'>>>>>>>>>>>>> I2C lines for BQ32000
Config Scl = Portc.5
Config Sda = Portc.4
Config I2cdelay = 100
Config Twi = 50000
I2cinit

'################################################ Timers configuration
Config Timer0 = Timer , Prescale = 8                        '7segment multiplexing
Enable Ovf0
Stop Timer0
On Ovf0 Displayupdate

Config Timer1 = Timer , Prescale = 8                        'alarm time handling
Enable Ovf1
Stop Timer1
On Ovf1 Alarmhandle

Config Timer2 = Timer , Prescale = 1024                     'used for blinking 7seg display while setting
Enable Ovf2
Stop Timer2
On Ovf2 Blinkdisplay

'################################################ Variables and constants
Const Rtc_r = &B11010001
Const Rtc_w = &B11010000

Dim I As Byte

Dim M As Byte
M = 0

Dim Al As Word                                              'alarm time counting
Al = 0

Dim T As Byte                                               'used in 7 seg multiplexing
Dim Tt As Word                                              'used in display mode ,also for fade away time/date displays
Dim U As Byte

Dim _hr As Byte , _min As Byte , _sec As Byte
Dim _pm As Bit
Dim _date As Byte , _month As Byte , _year As Byte , _day As Byte

Dim Alarmon As Bit
Dim Alarm_hr As Byte , Alarm_min As Byte
Dim Alarm_pm As Bit
Dim Alarmrunning As Bit                                     'alarm running flag
Alarmrunning = 0
Dim Alarmstopped As Bit                                     'alarm stopped externally flag
Alarmstopped = 0

Dim A As Byte , B As Byte , C As Byte , D As Byte           'used in 7 seg multiplexed data handling

Dim W As Word                                               'ADC data fetch variable
Dim V As Single

Dim Leftblink As Bit                                        'used to command blinking of left side
Dim Fullblink As Bit
Dim Switch_cd As Bit                                        'used in blinking control of left two displays
Dim Switch_ab As Bit                                        'used in blinking control of right two displays
Switch_ab = 1
Switch_cd = 1

'################################################################## Main program
'###############################################################################

'-------------------------------------------------------------------------------------
'BQ32000 general data writing (optional-mainly for OTP)
'I2cstart                                                    ' Generate start code
'I2cwbyte Rtc_w                                              ' send address
'I2cwbyte 0                                                  ' start address in bq32000

'I2cwbyte &B00000000                                         'stop bit and seconds,here the 7th bit contol the oscillator==> 0=normal,1=stop oscillator
'I2cwbyte &B01011001                                         'osc fail bit and minutes
'I2cwbyte &B00100011                                         'cent_hours

'I2cwbyte &B00000000                                         'day
'I2cwbyte &B00000011                                         'date
'I2cwbyte &B00000010                                         'month
'I2cwbyte &B00010100                                         'year

'I2cwbyte &B10000001                                         'CAL_CFG1
'I2cwbyte &B00000000                                         'TCH2
'I2cwbyte &B00000000                                         'CFG2

'I2cstop
'Waitms 10

'BQ32000 SFR data writing (optional-mainly for OTP)
'I2cstart
'I2cwbyte Rtc_w                                              ' send address
'I2cwbyte 32                                                 ' start address in bq32000

'I2cwbyte &B00000101                                         'SFR key 1=05
'I2cwbyte &B11000111                                         'SFR key 2=C7
'I2cwbyte &B00000001                                         'SFR

'I2cstop
'-------------------------------------------------------------------------------------

'---------Recover alarm data from EEPROM
Readeeprom Alarm_hr , 1
Readeeprom Alarm_min , 2
Readeeprom I , 3
Alarm_pm = I
Readeeprom I , 4
Alarmon = I

'---------------------------------------

Enable Interrupts
Call Blinkers_on                                            'turn ON the middle lights
Start Timer0                                                'start updating display

Do

      Call Rtcread                                          'read the BQ32000 RTC chip registers

      '@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
      If Alarmstopped = 0 Then

         If Alarmon = 1 And Alarmrunning = 0 And Alarm_hr = _hr And Alarm_min = _min And Alarm_pm = _pm Then       'if alarm time is reached,and alarm was previously not running

           Alarmstopped = 0                                 'alarm not stopped externally
           Alarmrunning = 1                                 'set alarmrunning flag
           Al = 0                                           'set the counter for time
           Start Timer1                                     'start 10 minute beep timer

         End If

      Else

         If Alarm_hr = _hr And Alarm_min = _min And Alarm_pm = _pm Then

           Stop Timer1                                      'stop alarm
           Set Portc.0

         Else

           Alarmstopped = 0
           Alarmrunning = 0

         End If

      End If
      '@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
      Select Case M

         Case 0:                                            'normal time display

            A = _min Mod 10
            B = _min / 10
            C = _hr Mod 10
            D = _hr / 10

            If _pm = 1 Then                                 'if PM,then show blue LED
               Blue = 0
               Red = 1
               Green = 1
            Else                                            'if AM,then show red LED
               Blue = 1
               Red = 1
               Green = 0
            End If

         '************************************************************* PLUS Button temp,alarm menu
         Case 1:                                            'blank

            Call Blanking

         Case 2:                                            'show temperature

            If Tt = 0 Then

              Call Blinkers_off
              Red = 1
              Green = 1
              Blue = 1

              D = 10                                        'show "t"
              C = 11                                        'show "-"

              Start Adc
              W = Getadc(3)                                 'read the temperature sensor outside the home
              V = W * 2.56
              V = V / 1023
              V = V * 100
              W = Abs(v)

              If W >= 0 And W <= 99 Then                    'if temp is within 0-99'C ,show it on display
                A = W Mod 10
                B = W / 10
              Else                                          'else show over temperature condition
                A = 11                                      ' show "-"
                B = 11                                      ' show "-"
              End If

              Stop Adc

              Tt = 181

            End If

         Case 3:                                            'blank

            Call Blanking

         Case 4:                                            'show alarm

            If Tt = 0 Then

              Call Blinkers_on

              A = Alarm_min Mod 10
              B = Alarm_min / 10

              C = Alarm_hr Mod 10
              D = Alarm_hr / 10

              If Alarm_pm = 1 Then                          'ALARM PM
                Red = 1
                Green = 1
                Blue = 0
              Else
                Red = 1
                Green = 0
                Blue = 1
              End If

              Tt = 181

            End If

         Case 5:                                            'blank

            Call Blanking

         '************************************************************* MINUS button date/month/year menu
         Case 6:                                            'show blank

            Call Blanking

         Case 7:                                            'show date and month

            If Tt = 0 Then

              Call Blinkers_off

              A = _month Mod 10
              B = _month / 10
              C = _date Mod 10
              D = _date / 10

              Red = 0
              Green = 1
              Blue = 1

              Tt = 181

            End If

         Case 8:                                            'blank

            Call Blanking

         Case 9:                                            'show year

            If Tt = 0 Then

              Call Blinkers_off

              A = _year Mod 10
              B = _year / 10
              C = 0
              D = 2

              Red = 0
              Green = 1
              Blue = 1

              Tt = 181

            End If

         Case 10:                                           'blank

            Call Blanking

      End Select
      '@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
      If Tt <> 0 Then

         Select Case M

           Case 1:

             Decr Tt
             If Tt = 1 Then
              M = 2
              Tt = 0
             End If

           Case 2:

             Decr Tt
             If Tt = 1 Then
              M = 3
              Tt = 0
             End If

           Case 3:

             Decr Tt
             If Tt = 1 Then
              M = 4
              Tt = 0
             End If

           Case 4:

             Decr Tt
             If Tt = 1 Then
              M = 5
              Tt = 0
             End If

           Case 5:

             Decr Tt
             If Tt = 1 Then

              Call Beep(200)
              M = 0                                         'revert back to normal time display now
              Tt = 0
              Call Blinkers_on

             End If
           '*******************************
           Case 6:

             Decr Tt
             If Tt = 1 Then
              M = 7
              Tt = 0
             End If

           Case 7:

             Decr Tt
             If Tt = 1 Then
              M = 8
              Tt = 0
             End If

           Case 8:

             Decr Tt
             If Tt = 1 Then
              M = 9
              Tt = 0
             End If

           Case 9:

             Decr Tt
             If Tt = 1 Then
              M = 10
              Tt = 0
             End If

           Case 10:

             Decr Tt
             If Tt = 1 Then

              Call Beep(200)
              M = 0
              Tt = 0
              Call Blinkers_on

             End If

         End Select

      End If
      '@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

      '>>>>>>>>>> Button PLUS event
      If B_plus = 0 Then                                    'button PLUS pressed

         Call Beep(200)                                     'make a small beep

         If Alarmrunning = 1 And Alarmstopped = 0 Then      'if alarm is beeping up,this button serves the function of turning it OFF

            Alarmstopped = 1                                'alarm is stopped externally
            Waitms 400

         Else

            M = 1                                           'turn the display mode to temp,alarm

         End If

      End If

      '>>>>>>>>>> Button MINUS event
      If B_minus = 0 Then                                   'button minus pressed

         Call Beep(200)                                     'make a small beep

         If Alarmrunning = 1 And Alarmstopped = 0 Then      'if alarm is beeping up,this button serves the function of turning it OFF

            Alarmstopped = 1                                'alarm is stopped externally
            Waitms 400

         Else

            Wait 1
            If B_minus = 0 Then                             'if minus button is pressed for more than 1 sec, change the alram to ON/OFF

              Call Blinkers_off

              Toggle Alarmon
              I = Alarmon
              Writeeeprom I , 4

              If Alarmon = 1 Then                           'show alarm is ON

                A = 1                                       '1
                B = 11                                      '-
                C = 16                                      'L
                D = 15                                      'A

              Else                                          'show alarm is OFF

                A = 0                                       '0
                B = 11                                      '-
                C = 16                                      'L
                D = 15                                      'A

              End If

              Wait 1

              Call Blinkers_on
              M = 0

            Else                                            'if minus button is pressed for not more than 1 sec

              M = 6                                         'turn the display mode to date,month,year

            End If

         End If

      End If

      '>>>>>>>>>> Button SET event
      If B_set = 0 Then                                     'button SET pressed

         Call Beep(1000)                                    'make a small beep

         If Alarmrunning = 1 And Alarmstopped = 0 Then      'if alarm is beeping up,this button serves the function of turning it OFF

            Alarmstopped = 1                                'alarm is stopped externally
            Waitms 400

         Else                                               'start the setting menu

            '////////////////////// Blank - 0.5 secondes
            Call Blinkers_off
            A = 12
            B = 12
            C = 12
            D = 12

            Waitms 500

            '////////////////////// Time setting
            Call Blinkers_on
            Call Rtcread

            '>>>> set hours
            Fullblink = 0                                   'do not blink the whole display
            Leftblink = 1                                   'making left side i.e. hours to blink
            Switch_ab = 1
            Start Timer2                                    'start blinking the display

            Do

                 A = _min Mod 10
                 B = _min / 10
                 C = _hr Mod 10
                 D = _hr / 10

                 If B_plus = 0 Then
                    Incr _hr

                    If _hr > 12 Then
                     _hr = 1
                     Toggle _pm
                    End If

                    Call Beep(300)
                 End If

                 If B_minus = 0 Then
                    Decr _hr

                    If _hr < 1 Then
                     _hr = 12
                     Toggle _pm
                    End If

                    Call Beep(300)
                 End If

                 If _pm = 1 Then
                  Red = 1
                  Green = 1
                  Blue = 0
                 Else
                  Red = 1
                  Green = 0
                  Blue = 1
                 End If

            Loop Until B_set = 0

            Call Beep(1000)

            If _hr = 12 And _pm = 0 Then                    '12:xx AM
              _hr = 0
            End If

            If _pm = 1 Then

              If _hr = 12 Then                              '12:xx PM
                 _hr = 12
              Else
                 _hr = _hr + 12
              End If

            End If

            I = Makebcd(_hr)
            I = I And &B00111111

            Call Writertcreg(2 , I)

            '>>>> set minutes
            Fullblink = 0                                   'do not blink the whle display
            Leftblink = 0                                   'making right side i.e. minutes to blink
            Switch_cd = 1
            Call Rtcread

            If _pm = 1 Then
             Red = 1
             Green = 1
             Blue = 0
            Else
             Red = 1
             Green = 0
             Blue = 1
            End If

            Do

              A = _min Mod 10
              B = _min / 10
              C = _hr Mod 10
              D = _hr / 10

              If B_plus = 0 Then
                 Incr _min
                 If _min > 59 Then _min = 0

                 Call Beep(300)
              End If

              If B_minus = 0 Then
                 Decr _min
                 If _min > 59 Then _min = 59

                 Call Beep(300)
              End If

            Loop Until B_set = 0

            Call Beep(1000)

            I = Makebcd(_min)
            I = I And &B01111111

            Call Writertcreg(1 , I)

            '>>>> show that the above settings are set successfully
            Call Display_set

            '////////////////////// Date-month setting
            Call Blinkers_off
            Call Rtcread

            Red = 0                                         'turn red led on to depict date/month/year display/processing
            Green = 1
            Blue = 1

            '>>>> set month now
            Fullblink = 0                                   'do not blink the whle display
            Leftblink = 0                                   'making right side i.e. months to blink
            Switch_cd = 1

            Do

                 A = _month Mod 10
                 B = _month / 10
                 C = _date Mod 10
                 D = _date / 10

                 If B_plus = 0 Then
                    Incr _month
                    If _month > 12 Then _month = 1
                    Call Beep(300)
                 End If

                 If B_minus = 0 Then
                    Decr _month
                    If _month < 1 Then _month = 12
                    Call Beep(300)
                 End If

            Loop Until B_set = 0

            Call Beep(1000)

            I = Makebcd(_month)
            I = I And &B00011111

            Call Writertcreg(5 , I)

            Call Rtcread

            '>>>> set date now
            Fullblink = 0                                   'do not blink the whle display
            Leftblink = 1                                   'making left side i.e. date to blink
            Switch_ab = 1

            Do

                 A = _month Mod 10
                 B = _month / 10
                 C = _date Mod 10
                 D = _date / 10

                 If B_plus = 0 Then
                    Incr _date

                    If _month = 1 Or _month = 3 Or _month = 5 Or _month = 7 Or _month = 8 Or _month = 10 Or _month = 12 Then       '31 days-jan,march,may,july,aug,oct,dec
                      If _date > 31 Then _date = 1
                    Elseif _month = 2 Then                  '28/29 days-FEB
                      If _date > 29 Then _date = 1
                    Else                                    '30 days months
                      If _date > 30 Then _date = 1
                    End If

                    Call Beep(300)
                 End If

                 If B_minus = 0 Then
                    Decr _date

                    If _month = 1 Or _month = 3 Or _month = 5 Or _month = 7 Or _month = 8 Or _month = 10 Or _month = 12 Then       '31 days-jan,march,may,july,aug,oct,dec
                      If _date < 1 Then _date = 31
                    Elseif _month = 2 Then                  '28/29 days-FEB
                      If _date < 1 Then _date = 29
                    Else                                    '30 days months
                      If _date < 1 Then _date = 30
                    End If

                    Call Beep(300)
                 End If

            Loop Until B_set = 0

            Call Beep(1000)

            I = Makebcd(_date)
            I = I And &B00111111

            Call Writertcreg(4 , I)

            '>>>> set year now
            Call Rtcread

            Fullblink = 1                                   'blink the whle display

            Do

              A = _year Mod 10
              B = _year / 10
              C = 0
              D = 2

              If B_plus = 0 Then
                 Incr _year
                 If _year > 99 Then _year = 0

                 Call Beep(300)
              End If

              If B_minus = 0 Then
                 Decr _year
                 If _year > 59 Then _year = 99

                 Call Beep(300)
              End If

            Loop Until B_set = 0

            Call Beep(1000)

            I = Makebcd(_year)

            Call Writertcreg(6 , I)

            '>>>> show that the above settings are set successfully
            Call Display_set

            '////////////////////// ALARM setting
            Call Blinkers_on

            Readeeprom Alarm_hr , 1
            Readeeprom Alarm_min , 2
            Readeeprom I , 3
            Alarm_pm = I

            '>>>> set alarm hours
            Fullblink = 0                                   'do not blink the whole display
            Leftblink = 1                                   'making left side i.e. hours to blink
            Switch_ab = 1

            Do

                 A = Alarm_min Mod 10
                 B = Alarm_min / 10
                 C = Alarm_hr Mod 10
                 D = Alarm_hr / 10

                 If B_plus = 0 Then
                    Incr Alarm_hr

                    If Alarm_hr > 12 Then
                     Alarm_hr = 1
                     Toggle Alarm_pm
                    End If

                    Call Beep(300)
                 End If

                 If B_minus = 0 Then
                    Decr Alarm_hr

                    If Alarm_hr < 1 Then
                     Alarm_hr = 12
                     Toggle Alarm_pm
                    End If

                    Call Beep(300)
                 End If

                 If Alarm_pm = 1 Then
                  Red = 1
                  Green = 1
                  Blue = 0
                 Else
                  Red = 1
                  Green = 0
                  Blue = 1
                 End If

            Loop Until B_set = 0

            Call Beep(1000)

            Writeeeprom Alarm_hr , 1
            I = Alarm_pm
            Writeeeprom I , 3

            Waitms 10
            Readeeprom Alarm_hr , 1
            Readeeprom Alarm_min , 2
            Readeeprom I , 3
            Alarm_pm = I


            '>>>> set Alarm minutes
            Fullblink = 0                                   'do not blink the whle display
            Leftblink = 0                                   'making right side i.e. minutes to blink
            Switch_cd = 1

            Do

              A = Alarm_min Mod 10
              B = Alarm_min / 10
              C = Alarm_hr Mod 10
              D = Alarm_hr / 10

              If B_plus = 0 Then
                 Incr Alarm_min
                 If Alarm_min > 59 Then Alarm_min = 0

                 Call Beep(300)
              End If

              If B_minus = 0 Then
                 Decr Alarm_min
                 If Alarm_min > 59 Then Alarm_min = 59

                 Call Beep(300)
              End If

            Loop Until B_set = 0

            Call Beep(1000)

            Writeeeprom Alarm_min , 2

            Waitms 10

            '>>>> show that the above settings are set successfully
            Call Display_set

            Stop Timer2
            M = 0                                           'return to normal time mode
            Switch_ab = 1
            Switch_cd = 1
            Call Blinkers_on

         End If

      End If
      '@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

      Waitms 1
Loop
End

'###############################################################################
'################################################ Display update [timer0 ISR]
Displayupdate:

Select Case T
 Case 0:                                                    'write 1st digit

     Call Cleardispdata                                     'clear display data lines

     If Switch_ab = 1 Then
      Set Portb.1
     Else
      Reset Portb.1
     End If

     Reset Portb.2
     Reset Portb.6
     Reset Portb.7

     Call Showdispdata(a)

 Case 1:                                                    'write 2nd digit

     Call Cleardispdata                                     'clear display data lines

     If Switch_ab = 1 Then
      Set Portb.2
     Else
      Reset Portb.2
     End If

     Reset Portb.1
     Reset Portb.6
     Reset Portb.7

     Call Showdispdata(b)

 Case 2:                                                    'write 3rd digit

     Call Cleardispdata                                     'clear display data lines

     If Switch_cd = 1 Then
      Set Portb.7
     Else
      Reset Portb.7
     End If

     Reset Portb.1
     Reset Portb.2
     Reset Portb.6

     Call Showdispdata(c)

 Case 3:                                                    'write 4th digit

     Call Cleardispdata                                     'clear display data lines

     If Switch_cd = 1 Then
      Set Portb.6
     Else
      Reset Portb.6
     End If

     Reset Portb.1
     Reset Portb.2
     Reset Portb.7

     Call Showdispdata(d)

  Case 4:

     T = 255                                                'so thet further increment will make it zero

End Select

Incr T

Return

'################################################ Clear 7 seg display [datalines only] subroutine
Sub Cleardispdata

  Reset Portd.0
  Reset Portd.1
  Reset Portd.4
  Reset Portd.5
  Reset Portd.6
  Reset Portd.7
  Reset Portb.0

  Reset Portb.1
  Reset Portb.2
  Reset Portb.6
  Reset Portb.7

End Sub

'################################################ write-update 7 seg display [datalines only] subroutine
Sub Showdispdata(byref E As Byte)

  Select Case E
     Case 0:

       Reset Portd.0
       Set Portd.1
       Set Portd.4
       Set Portd.5
       Set Portd.6
       Set Portd.7
       Set Portb.0

     Case 1:

       Reset Portd.0
       Reset Portd.1
       Reset Portd.4
       Reset Portd.5
       Set Portd.6
       Set Portd.7
       Reset Portb.0

     Case 2:

       Set Portd.0
       Reset Portd.1
       Set Portd.4
       Set Portd.5
       Reset Portd.6
       Set Portd.7
       Set Portb.0

     Case 3:

       Set Portd.0
       Reset Portd.1
       Reset Portd.4
       Set Portd.5
       Set Portd.6
       Set Portd.7
       Set Portb.0

     Case 4:

       Set Portd.0
       Set Portd.1
       Reset Portd.4
       Reset Portd.5
       Set Portd.6
       Set Portd.7
       Reset Portb.0

     Case 5:

       Set Portd.0
       Set Portd.1
       Reset Portd.4
       Set Portd.5
       Set Portd.6
       Reset Portd.7
       Set Portb.0

     Case 6:

       Set Portd.0
       Set Portd.1
       Set Portd.4
       Set Portd.5
       Set Portd.6
       Reset Portd.7
       Set Portb.0

     Case 7:

       Reset Portd.0
       Reset Portd.1
       Reset Portd.4
       Reset Portd.5
       Set Portd.6
       Set Portd.7
       Set Portb.0

     Case 8:

       Set Portd.0
       Set Portd.1
       Set Portd.4
       Set Portd.5
       Set Portd.6
       Set Portd.7
       Set Portb.0

     Case 9:

       Set Portd.0
       Set Portd.1
       Reset Portd.4
       Set Portd.5
       Set Portd.6
       Set Portd.7
       Set Portb.0

     Case 10:                                               'show "t"

       Set Portd.0
       Set Portd.1
       Set Portd.4
       Set Portd.5
       Reset Portd.6
       Reset Portd.7
       Reset Portb.0

     Case 11:                                               'show "-"

       Set Portd.0
       Reset Portd.1
       Reset Portd.4
       Reset Portd.5
       Reset Portd.6
       Reset Portd.7
       Reset Portb.0

     Case 12:                                               'show nothing,reset all

       Reset Portd.0
       Reset Portd.1
       Reset Portd.4
       Reset Portd.5
       Reset Portd.6
       Reset Portd.7
       Reset Portb.0

     Case 13:                                               'show "S"

       Set Portd.0
       Set Portd.1
       Reset Portd.4
       Set Portd.5
       Set Portd.6
       Reset Portd.7
       Set Portb.0

     Case 14:                                               'show "E"

       Set Portd.0
       Set Portd.1
       Set Portd.4
       Set Portd.5
       Reset Portd.6
       Reset Portd.7
       Set Portb.0

     Case 15:                                               'show "A"

       Set Portd.0
       Set Portd.1
       Set Portd.4
       Reset Portd.5
       Set Portd.6
       Set Portd.7
       Set Portb.0

     Case 16:                                               'show "L"

       Reset Portd.0
       Set Portd.1
       Set Portd.4
       Set Portd.5
       Reset Portd.6
       Reset Portd.7
       Reset Portb.0

  End Select

End Sub

'################################################ RTC read
Sub Rtcread

  I2cstart                                                  ' Generate start code
  I2cwbyte Rtc_w                                            ' send address
  I2cwbyte 0                                                ' start address in 1307
  I2cstart                                                  ' Generate start code
  I2cwbyte Rtc_r                                            ' send address

  I2crbyte _sec , Ack                                       ' seconds
  I2crbyte _min , Ack                                       ' minutes
  I2crbyte _hr , Ack                                        ' hours
  I2crbyte _day , Ack                                       ' day
  I2crbyte _date , Ack                                      ' date
  I2crbyte _month , Ack                                     ' month
  I2crbyte _year , Nack                                     ' year

  I2cstop

  _sec = _sec And &B01111111
  _sec = Makedec(_sec)

  _min = _min And &B01111111
  _min = Makedec(_min)

  _hr = _hr And &B00111111
  _hr = Makedec(_hr)

  'compensate for AM-PM calculations as BQ32000 can keep time only in 24-hour format
  If _hr >= 0 And _hr <= 11 Then                            'AM

     _pm = 0
     If _hr = 0 Then _hr = 12

  Elseif _hr >= 12 And _hr <= 23 Then                       'PM

     _pm = 1
     If _hr >= 13 And _hr <= 23 Then _hr = _hr - 12

  End If

  _day = _day And &B00000111
  _day = Makedec(_day)

  _date = _date And &B00111111
  _date = Makedec(_date)

  _month = _month And &B00011111
  _month = Makedec(_month)

  _year = Makedec(_year)

End Sub
'################################################ Alarm handle routine
Alarmhandle:

  If Al > 1145 Then                                         'apprx 10 minutes

   Stop Timer1                                              'stop alarm
   Al = 0
   Alarmrunning = 0
   Alarmstopped = 0
   Set Portc.0                                              'turn off buzzer

  End If

  I = Al Mod 2

  If I = 0 Then
    Set Portc.0
  Else
    Reset Portc.0
  End If

  Incr Al

Return
'############################################################# Turn on the two LEDs between segments
Sub Blinkers_on

  Call Writertcreg(7 , 173)

End Sub
'############################################################# Turn off the two LEDs between segments
Sub Blinkers_off

  Call Writertcreg(7 , 45)

End Sub
'############################################################# Blink routine for segments ,used in setting
Blinkdisplay:

  If U = 0 Then

     If Fullblink = 1 Then
        Switch_cd = 1
        Switch_ab = 1
     Else
        If Leftblink = 1 Then                               'if leftside is set to blink
         Switch_cd = 1
        Else                                                'if rightside is set to blink
         Switch_ab = 1
        End If
     End If

  End If

  If U = 1 Then

     If Fullblink = 1 Then
        Switch_cd = 0
        Switch_ab = 0
     Else
        If Leftblink = 1 Then                               'if leftside is set to blink
         Switch_cd = 0
        Else                                                'if rightside is set to blink
         Switch_ab = 0
        End If
     End If

  End If

  If U = 1 Then U = 255

  Incr U

Return
'################################################################ BEEPER routine
Sub Beep(byval Dur As Word)                                 'beep for a certain duration in milliseconds

  Reset Portc.0                                             'turn on buzzer
  Waitms Dur
  Set Portc.0                                               'turn off buzzer

End Sub
'################################################################ Display "SET" on 7 segment
Sub Display_set                                             'used to display "SET" on 7 segment

  Stop Timer2                                               'stop display blinking

  Call Blinkers_off
  'A = 12
  'B = 12
  'C = 12
  'D = 12
  'Waitms 300

  Switch_ab = 1
  Switch_cd = 1

  A = 10                                                    't
  B = 14                                                    'E
  C = 13                                                    'S
  D = 12                                                    'blank

  Call Beep(800)

  Start Timer2

End Sub
'########################################################################### BQ32000 single redister wrie routine
Sub Writertcreg(byval Address As Byte , Byval Value As Byte)       'used to write data to a register in RTC BQ32000

  Disable Interrupts

  Waitms 1

  I2cstart                                                  ' Generate start code
  I2cwbyte Rtc_w                                            ' send address
  I2cwbyte Address                                          ' start address in bq32000

  I2cwbyte Value
  I2cstop

  Waitms 1

  Enable Interrupts

End Sub
'########################################################################### Used to blank out the display
Sub Blanking

  If Tt = 0 Then
    Call Blinkers_off
    A = 12
    B = 12
    C = 12
    D = 12
    Red = 1
    Green = 1
    Blue = 1

    Tt = 31
  End If

End Sub